package com.ejie.p06b.n38.invoke;

import org.w3c.dom.Document;

import com.ejie.p06b.log.P06BLog;

import n38a.exe.N38APISesion;


public class SecurityHelperXLNets {

	/**
	 * Constructor por defecto
	 */
	private SecurityHelperXLNets() {
	}

	/**
	 * Mtodo que obtiene el token de XLNet asociado a una aplicacin
	 * determinada
	 * 
	 * @param idAplic
	 *            : Objeto de tipo String con el identificador de la aplicacin
	 * @return Devuelve un objeto Document con la respuesta del mtodo
	 *         n38APISesionCrearApp del servicio de XLNet (n38)
	 */
	public static Document getTokenXLNets(String idAplic) {
		Document token = null;

		try {
			N38APISesion miAPISesion = new N38APISesion();
			System.out.println(idAplic);
			token = miAPISesion.n38APISesionCrearApp(idAplic);
		} catch (Exception e) {
			P06BLog.send(0,SecurityHelperXLNets.class, "(getTokenXLNets) Error al intentar obtener el token de XLNet");
		}
		return token;
	}
	
}
